/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import jclass.bwt.BWTUtil;
import jclass.bwt.ComponentConverter;
import jclass.bwt.JCVersion;
import jclass.bwt.Shadow;
import jclass.util.JCConverter;
import jclass.util.JCEnvironment;
import jclass.util.JCFile;
import jclass.util.JCUtilConverter;

public abstract class JCComponent
extends Canvas {
    public static final String version = JCVersion.getVersionString();
    protected transient Applet applet;
    protected transient AppletContext applet_context;
    protected transient boolean in_repaint = false;
    protected transient boolean needs_layout = true;
    protected int highlight = 2;
    protected int shadow = 2;
    protected int shadow_type = 3;
    static final Object LOCK = new Object();
    static long popdown_time;
    boolean double_buffer = true;
    Color highlight_color;
    Object userdata;
    boolean has_focus = false;
    boolean traversable = true;
    int pref_width = -999;
    int pref_height = -999;
    Insets insets = new Insets(0, 0, 0, 0);
    static JCConverter conv;
    boolean do_repaint = true;
    transient Rectangle paint_rect;
    protected transient Graphics draw_gc;
    protected transient Image dblbuffer_image;
    transient Graphics dblbuffer_image_gc;
    private Rectangle rect = new Rectangle();
    private static final int[][] keyCodes;

    public JCComponent() {
        this(null, null);
    }

    public JCComponent(Applet applet, String string) {
        this.applet = applet;
        this.setName(string);
        if (this.getClass().getName().equals("jclass.bwt.JCComponent")) {
            this.getParameters(applet);
        }
    }

    String getParam(String string) {
        return conv.getParam(this.applet, this, this.getName(), string);
    }

    protected void getParameters() {
        ComponentConverter.getParams(this);
    }

    public void getParameters(Applet applet) {
        this.getParameters(applet, null);
    }

    public void getParameters(Applet applet, String string) {
        this.applet = applet;
        if (string == null) {
            string = this.getParam("paramFile");
        }
        if (string != null) {
            JCUtilConverter.setParamSource(this, JCFile.read(applet, string));
        }
        if (string != null || this.getAppletContext() != null) {
            this.getParameters();
            if (this.getPeer() != null) {
                this.addNotify();
                this.repaint();
            }
        }
    }

    public static void setConverter(JCConverter jCConverter) {
        conv = jCConverter;
    }

    public static JCConverter getConverter() {
        return conv;
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public synchronized void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    public synchronized void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public int getShadowThickness() {
        return this.shadow;
    }

    public void setShadowThickness(int n) {
        this.shadow = n;
        this.layout();
        this.repaint();
    }

    public int getHighlightThickness() {
        return this.highlight;
    }

    public synchronized void setHighlightThickness(int n) {
        this.highlight = n;
        this.layout();
        this.repaint();
    }

    public Color getHighlightColor() {
        if (this.highlight_color != null) {
            return this.highlight_color;
        }
        return Color.black;
    }

    public synchronized void setHighlightColor(Color color) {
        this.highlight_color = color;
        this.repaint();
    }

    public synchronized void setInsets(Insets insets) {
        this.insets = insets;
        this.layout();
        this.repaint();
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        int n = this.highlight + this.shadow;
        rectangle.reshape(n + this.insets.left, n + this.insets.top, Math.max(0, this.size().width - (2 * n + this.insets.left + this.insets.right)), Math.max(0, this.size().height - (2 * n + this.insets.top + this.insets.bottom)));
    }

    public int getDrawingAreaHeight() {
        int n = 2 * this.shadow + 2 * this.highlight + this.insets.top + this.insets.bottom;
        return Math.max(0, this.size().height - n);
    }

    public int getDrawingAreaWidth() {
        int n = 2 * this.shadow + 2 * this.highlight + this.insets.left + this.insets.right;
        return Math.max(0, this.size().width - n);
    }

    public Insets insets() {
        return this.insets;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Frame getFrame() {
        return BWTUtil.getFrame(this);
    }

    public void setCursor(int n) {
        BWTUtil.setCursor(this, n);
    }

    public synchronized void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.repaint();
        }
    }

    public synchronized void disable() {
        if (this.isEnabled()) {
            this.drawHighlight(false);
            super.disable();
            this.repaint();
        }
    }

    public boolean isTraversable() {
        return this.traversable && this.isEnabled() && this.isShowing();
    }

    public boolean isFocusTraversable() {
        return this.traversable;
    }

    public void setTraversable(boolean bl) {
        this.traversable = bl;
    }

    public Object getUserData() {
        return this.userdata;
    }

    public int getUserDataInt() {
        if (this.userdata instanceof Integer) {
            return (Integer)this.userdata;
        }
        return 0;
    }

    public void setUserData(Object object) {
        this.userdata = object;
    }

    public synchronized void layout() {
        this.needs_layout = false;
    }

    public synchronized void reshape(Rectangle rectangle) {
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Image getDoubleBufferImage() {
        return this.dblbuffer_image;
    }

    public synchronized Graphics getDoubleBufferGraphics() {
        Image image = this.dblbuffer_image;
        this.dblbuffer_image = BWTUtil.createImage(this, this.size().width, this.size().height);
        if (this.dblbuffer_image == null) {
            this.dblbuffer_image_gc = null;
        } else if (this.dblbuffer_image != image) {
            this.dblbuffer_image_gc = this.dblbuffer_image.getGraphics();
        }
        return this.dblbuffer_image_gc;
    }

    public synchronized void repaint() {
        this.repaint(0, 0, this.size().width, this.size().height);
    }

    public synchronized void repaint(Rectangle rectangle) {
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void repaint(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics == null) {
            return;
        }
        this.in_repaint = true;
        graphics.setClip(n, n2, n3, n4);
        this.paint(graphics);
        this.in_repaint = false;
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (this.getPeer() == null || !this.isShowing() || n3 <= 0 || n4 <= 0 || this.in_repaint) {
            return;
        }
        int n5 = this.size().width;
        int n6 = this.size().height;
        if (n5 <= n || n6 <= n2 || n + n3 < 0 || n2 + n4 < 0) {
            return;
        }
        if (n + n3 > n5) {
            n3 = n5 - n;
        }
        if (n2 + n4 > n6) {
            n4 = n6 - n2;
        }
        Graphics graphics = this.getGraphics();
        this.repaint(graphics, n, n2, n3, n4);
        graphics.dispose();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void updateParent() {
        if (this.getParent() != null) {
            this.invalidate();
            this.getParent().invalidate();
            this.getParent().validate();
        }
    }

    protected synchronized void paintComponent(Graphics graphics) {
    }

    protected void fillBackground(Graphics graphics) {
        graphics.fillRect(0, 0, this.size().width, this.size().height);
    }

    final boolean intersects(Rectangle rectangle, int n) {
        if (rectangle == null) {
            return true;
        }
        int n2 = n;
        int n3 = n;
        int n4 = n3 + this.size().height - 2 * n;
        int n5 = n2 + this.size().width - 2 * n;
        return n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width || n5 >= rectangle.x && n5 <= rectangle.x + rectangle.width || n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height || n4 >= rectangle.y && n4 <= rectangle.y + rectangle.height;
    }

    protected void drawHighlight(boolean bl) {
        Graphics graphics;
        if (this.isShowing() && (graphics = this.getGraphics()) != null) {
            this.drawHighlight(graphics, bl);
            graphics.dispose();
        }
    }

    protected void drawHighlight(Graphics graphics, boolean bl) {
        Color color;
        if (this.highlight == 0) {
            return;
        }
        if (!this.intersects(this.paint_rect, this.highlight)) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.size().width;
        int n4 = this.size().height;
        Color color2 = bl ? this.highlight_color : (color = BWTUtil.instanceOf(this.getParent(), "JCSpinBox") ? this.getBackground() : this.getParent().getBackground());
        if (color == null) {
            color = Color.black;
        }
        graphics.setColor(color);
        int n5 = 0;
        while (n5 < this.highlight) {
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            ++n5;
            ++n;
            ++n2;
            n3 -= 2;
            n4 -= 2;
        }
    }

    protected void drawShadow(Graphics graphics) {
        if (!this.intersects(this.paint_rect, this.highlight + this.shadow)) {
            return;
        }
        Shadow.draw(graphics, this.shadow_type, this.shadow, this.highlight, this.highlight, this.size().width - 2 * this.highlight, this.size().height - 2 * this.highlight, this.getBackground(), this.getForeground());
    }

    void drawHighlightAndShadow(Graphics graphics) {
        this.drawHighlight(graphics, this.has_focus);
        if (this.shadow > 0 && this.shadow_type != 0) {
            this.drawShadow(graphics);
        }
    }

    public Rectangle getPaintRect() {
        return this.paint_rect;
    }

    public synchronized void paint(Graphics graphics) {
        if (graphics == null || this.getBackground() == null) {
            return;
        }
        this.draw_gc = graphics;
        this.paint_rect = graphics.getClipRect();
        if (this.double_buffer) {
            graphics = this.getDoubleBufferGraphics();
            if (graphics == null) {
                graphics = this.draw_gc;
            }
            this.dblbuffer_image = this.getDoubleBufferImage();
            if (this.paint_rect != null) {
                graphics.setClip(this.paint_rect);
            }
        }
        if (this.paint_rect == null) {
            this.paint_rect = new Rectangle(this.size());
            graphics.setClip(this.paint_rect);
        }
        this.rect.reshape(0, 0, this.size().width, this.size().height);
        graphics.setColor(this.getBackground());
        this.fillBackground(graphics);
        this.drawHighlightAndShadow(graphics);
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        this.getDrawingArea(this.rect);
        graphics.clipRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        Image image = this.dblbuffer_image;
        this.paintComponent(graphics);
        if (this.double_buffer && this.dblbuffer_image != null) {
            this.draw_gc.drawImage(this.dblbuffer_image, 0, 0, null);
            if (image != this.dblbuffer_image) {
                this.drawHighlightAndShadow(this.draw_gc);
            }
        }
        this.dblbuffer_image = image;
        this.draw_gc = null;
        this.paint_rect = null;
    }

    public void printAll(Graphics graphics) {
        boolean bl = this.double_buffer;
        this.double_buffer = false;
        super.printAll(graphics);
        this.double_buffer = bl;
    }

    protected void enable11Events(long l) {
        this.enableEvents(l);
    }

    public void addNotify() {
        if (this.getPeer() == null) {
            super.addNotify();
        }
        if (this.applet == null) {
            this.applet = BWTUtil.getApplet(this);
        }
        this.applet_context = this.getAppletContext();
        this.enable11Events(28L);
    }

    public AppletContext getAppletContext() {
        return BWTUtil.getAppletContext(this.applet);
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    protected int preferredWidth() {
        return -1;
    }

    protected int preferredHeight() {
        return -1;
    }

    public void setPreferredSize(int n, int n2) {
        this.pref_width = n;
        this.pref_height = n2;
    }

    public Dimension preferredSize() {
        int n = this.pref_width != -999 ? this.pref_width : (this.getPeer() != null ? this.preferredWidth() : 0);
        int n2 = n = n < 0 ? 50 : n + 2 * this.shadow + 2 * this.highlight + this.insets.left + this.insets.right;
        int n3 = this.pref_height != -999 ? this.pref_height : (this.getPeer() != null ? this.preferredHeight() : 0);
        n3 = n3 < 0 ? 50 : n3 + 2 * this.shadow + 2 * this.highlight + this.insets.top + this.insets.bottom;
        return new Dimension(n, n3);
    }

    public boolean getDoubleBuffer() {
        return this.double_buffer;
    }

    public void setDoubleBuffer(boolean bl) {
        this.double_buffer = bl;
    }

    public boolean hasFocus() {
        return this.has_focus;
    }

    public boolean lostFocus(Event event, Object object) {
        super.lostFocus(event, object);
        this.has_focus = false;
        if (this.isShowing()) {
            this.drawHighlight(false);
        }
        return true;
    }

    public boolean gotFocus(Event event, Object object) {
        if (!this.isEnabled()) {
            this.drawHighlight(false);
            return true;
        }
        super.gotFocus(event, object);
        this.has_focus = true;
        if (this.isShowing()) {
            this.drawHighlight(true);
        }
        return true;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        Event event = new Event(this, 0L, focusEvent.getID(), 0, 0, 0, 0);
        switch (event.id) {
            case 1005: {
                this.lostFocus(event, this);
                break;
            }
            case 1004: {
                this.gotFocus(event, this);
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    static final Event convertEvent(Component component, KeyEvent keyEvent) {
        int n = keyEvent.getKeyChar();
        int n2 = keyEvent.getKeyCode();
        int n3 = 0;
        while (n3 < keyCodes.length) {
            if (keyCodes[n3][0] == n2) {
                n = keyCodes[n3][1];
                break;
            }
            ++n3;
        }
        return new Event(component, keyEvent.getWhen(), keyEvent.getID(), 0, 0, n, keyEvent.getModifiers());
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        switch (n) {
            case 401: {
                int n2;
                if (keyEvent.isActionKey()) {
                    n = 403;
                }
                if ((n2 = keyEvent.getKeyCode()) == 16 || n2 == 17 || n2 == 18) {
                    return;
                }
                Event event = JCComponent.convertEvent(this, keyEvent);
                this.keyDown(event, event.key);
            }
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers());
        event.clickCount = mouseEvent.getClickCount();
        switch (event.id) {
            case 501: {
                if (event.when - popdown_time <= 50L && JCEnvironment.getOS() != 1) break;
                this.mouseDown(event, event.x, event.y);
                break;
            }
            case 502: {
                this.mouseUp(event, event.x, event.y);
                break;
            }
            case 504: {
                this.mouseEnter(event, event.x, event.y);
                break;
            }
            case 505: {
                this.mouseExit(event, event.x, event.y);
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers());
        switch (event.id) {
            case 503: {
                this.mouseMove(event, event.x, event.y);
                break;
            }
            case 506: {
                this.mouseDrag(event, event.x, event.y);
                break;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (event.when - popdown_time < 50L && JCEnvironment.getOS() != 1) {
            return true;
        }
        if (BWTUtil.getMouseButton(event) == 1 && this.isTraversable()) {
            this.requestFocus();
        }
        return false;
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.isTraversable()) {
            this.handleEvent(new Event(this, 1004, null));
        }
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = this.size().width != n3 || this.size().height != n4;
        if (!bl && this.location().x == n && this.location().y == n2) {
            return;
        }
        super.reshape(n, n2, n3, n4);
        if (JCEnvironment.getJavaVersion() == 110) {
            this.layout();
        }
        if (this.do_repaint) {
            this.repaint();
        }
    }

    public void validate() {
        if (this.isValid() || this.getPeer() == null) {
            return;
        }
        super.validate();
        if (JCEnvironment.getJavaVersion() == 110) {
            this.layout();
        }
    }

    public Image createImage(int n, int n2) {
        Dimension dimension = this.getToolkit().getScreenSize();
        n = Math.max(1, Math.min(n, dimension.width));
        n2 = Math.max(1, Math.min(n2, dimension.height));
        Image image = null;
        try {
            image = super.createImage(n, n2);
        }
        catch (Throwable throwable) {}
        return image;
    }

    void copyArea(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    static {
        conv = new JCConverter();
        keyCodes = new int[][]{{127, 127}, {40, 1005}, {35, 1001}, {10, 10}, {36, 1000}, {37, 1006}, {34, 1003}, {33, 1002}, {39, 1007}, {38, 1004}};
    }
}

